/*
 * Decompiled with CFR 0.152.
 */
package weka.classifiers.rules.lad.util;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFileChooser;
import weka.classifiers.rules.LAD;
import weka.classifiers.rules.lad.binarization.Cutpoints;
import weka.classifiers.rules.lad.ruleManager.RuleManager;

public class LADFileManager
implements Serializable {
    private static final long serialVersionUID = 940441734407639248L;
    private String pathname = new JFileChooser().getFileSystemView().getDefaultDirectory().toString();
    private boolean writable;
    private BufferedWriter writer;
    private static final String newline = System.getProperty("line.separator");

    public LADFileManager(String name, boolean addtime) {
        this.pathname = String.valueOf(this.pathname) + File.separator + "LAD " + name + " " + (addtime ? LADFileManager.getTime() : "") + ".txt";
        this.setFile(new File(this.pathname));
    }

    public void write(String txt) {
        if (this.isWritable()) {
            try {
                this.writer.append(String.valueOf(txt) + newline);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.setFile(null);
            }
        }
    }

    public void setFile(File file) {
        if (file != null && !file.getPath().isEmpty() && !file.isDirectory()) {
            try {
                this.writer = new BufferedWriter(new FileWriter(file, true));
                this.writable = true;
            }
            catch (IOException e) {
                e.printStackTrace();
                this.setFile(null);
            }
        } else {
            this.writer = null;
            this.writable = false;
        }
    }

    public boolean isWritable() {
        return this.writable;
    }

    public void restore() {
        this.setFile(new File(this.pathname));
    }

    public void close() {
        if (this.writer != null) {
            try {
                try {
                    this.writer.flush();
                    this.writer.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.setFile(null);
                }
            }
            finally {
                this.setFile(null);
            }
        }
    }

    public void write(LAD lad, String dataName) {
        if (this.isWritable()) {
            this.write(LADFileManager.writeHeader("LAD-WEKA pattern-space representation"));
            String s = LADFileManager.writeSection("Run Informations");
            s = String.valueOf(s) + " Scheme:" + LADFileManager.TAB(3) + LAD.class.getName();
            String[] op = lad.getOptions();
            int i = 0;
            while (i < op.length) {
                s = String.valueOf(s) + " " + op[i];
                ++i;
            }
            this.write(s);
            this.write(" Training Set:" + LADFileManager.TAB(2) + dataName);
            this.write(" Generation Date: " + LADFileManager.TAB(1) + LADFileManager.getTime() + "\n");
            lad.getCutpoints().sort();
            this.write(LADFileManager.write(lad.getCutpoints(), true));
            this.write(LADFileManager.write(lad.getRuleManager()));
            this.write(LADFileManager.writeHeader("Pattern-space representation of test set"));
            this.write("@RELATION " + dataName + "_PS\n");
            int numRules = lad.getRuleManager().numPositiveRules();
            int i2 = 0;
            while (i2 < numRules) {
                this.write("@ATTRIBUTE P" + (i2 + 1) + " NUMERIC");
                ++i2;
            }
            numRules = lad.getRuleManager().numNegativeRules();
            i2 = 0;
            while (i2 < numRules) {
                this.write("@ATTRIBUTE N" + (i2 + 1) + " NUMERIC");
                ++i2;
            }
            this.write("@ATTRIBUTE class {0,1}");
            this.write("\n@DATA");
        }
    }

    public static String write(Cutpoints cutpoints) {
        return LADFileManager.write(cutpoints, false);
    }

    public static String write(Cutpoints cutpoints, boolean listAll) {
        if (cutpoints == null) {
            return "";
        }
        String s = "";
        s = listAll ? String.valueOf(s) + LADFileManager.writeSection("Cutpoints", cutpoints) : String.valueOf(s) + LADFileManager.writeSection("Cutpoints");
        return String.valueOf(s) + " # Total: " + cutpoints.numCutpoints() + " cutpoints\n";
    }

    public static String write(RuleManager ruleManager) {
        return LADFileManager.writeSection("Summary of Patterns", ruleManager);
    }

    public static String writeHeader(String title) {
        return "=== " + title + " ===\n";
    }

    public static String writeSection(String title) {
        return " == " + title + " ===\n\n";
    }

    public static String write(String title, String msg) {
        return String.valueOf(LADFileManager.writeSection(title)) + msg;
    }

    public static String writeSection(String title, Object o) {
        return String.valueOf(LADFileManager.writeSection(title)) + (o != null ? o.toString() : "") + "\n";
    }

    public static String TAB(int times) {
        String s = "";
        int i = 0;
        while (i < times) {
            s = String.valueOf(s) + "\t";
            ++i;
        }
        return s;
    }

    public static String getTime() {
        return new SimpleDateFormat("MM.dd.yyyy HH.mm.ss").format(new Date());
    }
}

